/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWWorkflowMapPanel
extends JPanel
implements ListSelectionListener,
ChangeListener {
    private static final int COL_STEP = 0;
    private static final int COL_MAP = 1;
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private VWToolbarBorder m_mapBorder = null;
    private VWToolbarBorder m_descriptionBorder = null;
    private VWToolbarBorder m_refTableBorder = null;
    private Vector m_maps = null;
    private JList m_mapList = null;
    private AbstractListModel m_mapListModel = null;
    private JTextArea m_description = null;
    private VWTable m_refTable = null;
    private JScrollPane m_scrollPane = null;
    private VWReferenceTableModel m_refTableModel = null;
    private DefaultTableCellRenderer m_cellRenderer = null;

    public VWWorkflowMapPanel(Frame parentFrame, VWTrkDataModel dataModel) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_trackerDataModel = dataModel;
            this.initializeVars();
            this.setupLayout();
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void initialize() {
        try {
            if (this.m_trackerDataModel.getInitState() == 6) {
                Vector maps = (Vector)this.m_trackerDataModel.getMaps().clone();
                this.m_maps = new Vector();
                String thisMapName = null;
                String name = null;
                VWTrkMap mainMap = null;
                VWTrkMap map = null;
                Object obj = null;
                if (maps != null) {
                    for (int i = 0; i < maps.size(); ++i) {
                        obj = maps.elementAt(i);
                        if (obj == null || !(obj instanceof VWTrkMap)) continue;
                        map = obj;
                        if (map.isMainmap()) {
                            mainMap = map;
                            continue;
                        }
                        thisMapName = map.getMapDefinition().getName();
                        if (thisMapName == null) continue;
                        int j = 0;
                        for (j = 0; !(j >= this.m_maps.size() || (obj = this.m_maps.elementAt(j)) != null && obj instanceof VWTrkMap && (name = ((VWTrkMap)obj).getMapDefinition().getName()) != null && VWStringUtils.compareIgnoreCase(thisMapName, name) < 0); ++j) {
                        }
                        this.m_maps.insertElementAt(map, j);
                    }
                    if (mainMap != null) {
                        this.m_maps.insertElementAt(mainMap, 0);
                    }
                }
                if (this.m_mapList != null) {
                    this.m_mapList.updateUI();
                }
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    private void initializeVars() {
        try {
            this.m_mapListModel = new AbstractListModel(){

                public int getSize() {
                    if (VWWorkflowMapPanel.this.m_maps != null) {
                        return VWWorkflowMapPanel.this.m_maps.size();
                    }
                    return 0;
                }

                public Object getElementAt(int index) {
                    if (VWWorkflowMapPanel.this.m_maps == null || index >= VWWorkflowMapPanel.this.m_maps.size()) {
                        return null;
                    }
                    Object obj = VWWorkflowMapPanel.this.m_maps.elementAt(index);
                    if (obj instanceof VWTrkMap) {
                        VWTrkMap map = (VWTrkMap)obj;
                        return new String(map.getMapDefinition().getName());
                    }
                    return null;
                }
            };
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
        try {
            this.m_refTableModel = new VWReferenceTableModel();
            DefaultTableCellRenderer m_cellRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                    if (value instanceof String) {
                        ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip((String)value, 0));
                    }
                    return component;
                }
            };
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    private void setupLayout() {
        try {
            GridBagConstraints c = new GridBagConstraints();
            JPanel panel = null;
            this.m_mapBorder = new VWToolbarBorder(VWResource.s_maps, 0);
            panel = this.m_mapBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_mapList = new JList(this.m_mapListModel);
            this.m_mapList.setSelectionMode(0);
            this.m_mapList.setSelectedIndex(-1);
            this.m_mapList.addListSelectionListener(this);
            JScrollPane scrollPane = new JScrollPane(this.m_mapList);
            panel.add((Component)scrollPane, "Center");
            this.m_descriptionBorder = new VWToolbarBorder(VWResource.s_description, 0);
            panel = this.m_descriptionBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_description = new JTextArea(3, 10);
            this.m_description.setEditable(false);
            this.m_description.setLineWrap(true);
            this.m_description.setWrapStyleWord(true);
            scrollPane = new JScrollPane(this.m_description);
            panel.add((Component)scrollPane, "Center");
            this.m_refTableBorder = new VWToolbarBorder(VWResource.s_callingSteps, 0);
            panel = this.m_refTableBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_refTable = new VWTable(this.m_refTableModel);
            TableColumnModel columnModel = this.m_refTable.getColumnModel();
            TableColumn columnMap = columnModel.getColumn(1);
            TableColumn columnStep = columnModel.getColumn(0);
            columnMap.setMinWidth(100);
            columnStep.setMinWidth(100);
            columnStep.setCellRenderer(this.m_cellRenderer);
            columnMap.setCellRenderer(this.m_cellRenderer);
            this.m_scrollPane = new JScrollPane(this.m_refTable);
            panel.add((Component)this.m_scrollPane, "Center");
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 23;
            c.insets = new Insets(0, 6, 0, 0);
            this.add((Component)this.m_mapBorder, c);
            c.gridy = -1;
            this.add((Component)this.m_descriptionBorder, c);
            this.add((Component)this.m_refTableBorder, c);
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void stateChanged(ChangeEvent e) {
        try {
            JTabbedPane tabbedPane;
            if (e.getSource() instanceof JTabbedPane && (tabbedPane = (JTabbedPane)e.getSource()).getSelectedComponent() == this) {
                this.m_refTable.fitColumnsInTable();
                this.m_mapList.setSelectedIndex(0);
                tabbedPane.removeChangeListener(this);
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            Object obj;
            if (e.getValueIsAdjusting()) {
                return;
            }
            Vector refSteps = null;
            int index = this.m_mapList.getSelectedIndex();
            if (this.m_maps != null && index >= 0 && index < this.m_maps.size() && (obj = this.m_maps.elementAt(index)) != null && obj instanceof VWTrkMap) {
                VWTrkMap map = (VWTrkMap)obj;
                String description = map.getMapDefinition().getDescription();
                this.m_description.setText(map.getMapDefinition().getDescription());
                refSteps = map.getCallingSteps();
                if (this.m_refTableModel == null) {
                    this.m_refTableModel = new VWReferenceTableModel(refSteps);
                } else {
                    this.m_refTableModel.setData(refSteps);
                }
                this.m_refTableModel.fireTableDataChanged();
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        if (this.m_scrollPane != null) {
            this.m_scrollPane.removeAll();
            this.m_scrollPane = null;
        }
        if (this.m_mapBorder != null) {
            this.m_mapBorder.removeReferences();
            this.m_mapBorder = null;
        }
        if (this.m_descriptionBorder != null) {
            this.m_descriptionBorder.removeReferences();
            this.m_descriptionBorder = null;
        }
        if (this.m_refTableBorder != null) {
            this.m_refTableBorder.removeReferences();
            this.m_refTableBorder = null;
        }
        if (this.m_maps != null) {
            this.m_maps.removeAllElements();
            this.m_maps = null;
        }
        this.m_mapList = null;
        this.m_mapListModel = null;
        if (this.m_refTable != null) {
            this.m_refTable.getColumnModel().getColumn(0).setCellRenderer(null);
            this.m_refTable.removeReferences();
            this.m_refTable = null;
        }
        if (this.m_refTableModel != null) {
            this.m_refTableModel.removeReferences();
            this.m_refTableModel = null;
        }
        this.m_cellRenderer = null;
        this.m_description = null;
    }

    private class VWReferenceTableModel
    extends AbstractTableModel {
        Vector m_data = null;
        String[] m_columnNames = new String[]{VWResource.s_step, VWResource.s_callerMap};

        VWReferenceTableModel() {
            this.m_data = null;
        }

        VWReferenceTableModel(Vector data) {
            this.m_data = data;
        }

        public void setData(Vector data) {
            this.m_data = data;
        }

        public int getRowCount() {
            if (this.m_data != null) {
                return this.m_data.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            VWTrkStep step = null;
            Object obj = this.m_data.elementAt(row);
            if (obj == null || !(obj instanceof VWTrkStep)) {
                return null;
            }
            step = (VWTrkStep)obj;
            switch (col) {
                case 1: {
                    int mapId = step.getMapId();
                    VWTrkMap map = VWWorkflowMapPanel.this.m_trackerDataModel.getMap(mapId);
                    if (map != null) {
                        return map.getMapDefinition().getName();
                    }
                    return null;
                }
                case 0: {
                    return step.getStepName();
                }
            }
            return null;
        }

        void removeReferences() {
            this.m_data = null;
            if (this.m_columnNames != null) {
                for (int i = 0; i < this.m_columnNames.length; ++i) {
                    this.m_columnNames[i] = null;
                }
                this.m_columnNames = null;
            }
        }
    }
}

